global files "C:/Users/WB326023/Dropbox/WB/BPEA/BPEA Replication/"
global BPEAraw "$files/dataraw"
global BPEAout "$files/dataout"
global BPEAtemp "$files/temp"
global BPEAplots "$files/plots"

/*
use "$BPEAout/panjiva/suppliers.dta", clear
merge 1:1 firm t tnum using "$BPEAout/panjiva/supplier_risk.dta"
drop if _m==2
drop _m 

merge m:1 firm using "$BPEAout/panjiva/panjiva_USA_import_firmHS.dta"

keep firm t risk_deaths risk_lockdown n  nsuppliers scale netseparationrate
compress 

save "$BPEAout\panjiva\regression_data.dta", replace*/

use "$BPEAout\panjiva\regression_data.dta", clear

recode risk_* (.=0)
sum risk_lockdown 
replace risk_lockdown  = risk_lockdown /r(max)

sum risk_deaths
replace risk_deaths = risk_deaths /r(max)

gen risk_lockdown_X_n = risk_lockdown*n

lab var risk_lockdown "Supplier Risk [0,1]"
lab var risk_lockdown_X_n "Supplier Risk X Share Differentiated"

reghdfe netseparationrate risk_lockdown risk_lockdown_X_n, absorb(firm t) cluster(firm)

outreg2 using "$BPEAplots/risk_regs",  word dec(2) addtext(Firm fixed effects,Yes,Quarter fixed effects, Yes) ctitle("Net sep. rate") label  nocons replace

sum scale
replace scale = (scale - r(mean))/r(sd)

sum nsuppliers
replace nsuppliers = (nsuppliers - r(mean))/r(sd)

gen risk_lockdown_X_nsuppliers = risk_lockdown*nsuppliers
lab var risk_lockdown_X_nsuppliers "Supplier Risk X Z(Number of suppliers)"

reghdfe netseparationrate risk_lockdown risk_lockdown_X_nsuppliers, absorb(firm t)  cluster(firm)

outreg2 using "$BPEAplots\risk_regs",  word dec(2) addtext(Firm fixed effects,Yes,Quarter fixed effects, Yes) ctitle("Net sep. rate") label  nocons 

gen risk_lockdown_X_scale = risk_lockdown*scale
lab var risk_lockdown_X_scale "Supplier Risk X Z(Supply volume)"

reghdfe netseparationrate risk_lockdown risk_lockdown_X_scale, absorb(firm t) cluster(firm)

outreg2 using "$BPEAplots\risk_regs",  word dec(2) addtext(Firm fixed effects,Yes,Quarter fixed effects, Yes) ctitle("Net sep. rate") label  nocons 


/*reghdfe netseparationrate risk_lockdown risk_lockdown_X_d, absorb(firm t) 
reghdfe entryrate risk_lockdown risk_lockdown_X_d, absorb(firm t)

reghdfe separationrate risk_deaths risk_deaths_X_d, absorb(firm) 
reghdfe entryrate  risk_deaths risk_deaths_X_d, absorb(firm)*/